---
generated_at: 2026-01-27 12:57:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-npm run test-e2e-webgpu.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - scripts.test-e2e-webgpu定義
- E-02: `test/e2e/puppeteer.js` - メイン処理実装（--webgpuフラグ処理）
- E-03: `バッチ一覧.csv` - バッチ定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンドは`node test/e2e/puppeteer.js --webgpu`を実行 | E-01 | ○ |
| C-02 | --webgpuフラグでisWebGPUがtrueになる | E-02 (lines 164-167) | ○ |
| C-03 | 'webgpu_'を含むファイルのみにフィルタリング | E-02 (line 202) | ○ |
| C-04 | test-e2eと同じ処理パラメータを使用 | E-02 (lines 95-110) | ○ |
| C-05 | SwiftShaderを使用してブラウザ起動 | E-02 (lines 219-224) | ○ |
| C-06 | ポート1234でサーバー起動 | E-02 (line 95) | ○ |
| C-07 | pixelThreshold=0.1、maxDifferentPixels=0.3% | E-02 (lines 96-97) | ○ |
| C-08 | numAttempts=2（リトライ回数） | E-02 (line 104) | ○ |
| C-09 | networkTimeout=5分、renderTimeout=5秒 | E-02 (lines 102-103) | ○ |
| C-10 | 例外リストにwebgpu関連のexampleが多数含まれる | E-02 (lines 69-89) | ○ |
| C-11 | --makeフラグと組み合わせ可能 | E-02 (lines 171-176) | ○ |
| C-12 | 差分画像は3種類出力される | E-02 (lines 546-548) | ○ |
| C-13 | 決定論的スクリプトを注入 | E-02 (lines 240-243, 300) | ○ |
| C-14 | build/three.webgpu.jsを読み込む | E-02 (line 247) | ○ |
| C-15 | 結果はコンソールに色付きで出力 | E-02 (lines 112-114) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - test-e2eのサブセットとして同一コードを使用
- 0: 低リスク - --webgpuフラグによるフィルタリングはシンプル

## 6) レビュアーチェックリスト（最小）
- [ ] 例外リストのwebgpu関連エントリが適切に設定されているか確認
- [ ] 新規webgpu exampleが追加された際にテスト対象に含まれるか確認
